% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{DRW}
\alias{DRW}
\title{Damped Random Walk Prior}
\usage{
DRW(
  s = 1,
  sd = 1,
  shape1 = 5,
  shape2 = 5,
  min = 0.8,
  max = 0.98,
  along = NULL,
  con = c("none", "by")
)
}
\arguments{
\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{sd}{Standard deviation
of initial value. Default is \code{1}.
Can be \code{0}.}

\item{shape1, shape2}{Parameters for beta-distribution prior
for damping coefficient. Defaults are \code{5} and \code{5}.}

\item{min, max}{Minimum and maximum values
for damping coefficient.
Defaults are \code{0.8} and \code{0.98}.}

\item{along}{Name of the variable to be used
as the 'along' variable. Only used with
interactions.}

\item{con}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Constraints on parameters.
Current choices are \code{"none"} and \code{"by"}.
Default is \code{"none"}. See below for details.}
}
\value{
An object of class \code{"bage_prior_drwrandom"}
or \code{"bage_prior_drwzero"}.
}
\description{
Use a damped random walk as a model for
a main effect, or use multiple damped random walks
as a model for an interaction.
Typically used with terms that involve time,
particularly in forecasts.
Damping often improves forecast accuracy.
}
\details{
If \code{DRW()} is used with an interaction,
a separate damped random walk is constructed
within each combination of the
'by' variables.

Arguments \code{min} and \code{max} can be used to control
the amount of damping that occurs.

Argument \code{s} controls the size of innovations.
Smaller values for \code{s} tend to produce smoother series.

Argument \code{sd} controls variance in
initial values. Setting \code{sd} to \code{0} fixes initial
values at 0.
}
\section{Mathematical details}{


When \code{DRW()} is used with a main effect,

\deqn{\beta_1 \sim \text{N}(0, \mathtt{sd}^2)}
\deqn{\beta_j \sim \text{N}(\phi \beta_{j-1}, \tau^2), \quad j > 1}

and when it is used with an interaction,

\deqn{\beta_{u,1} \sim \text{N}(0, \mathtt{sd}^2)}
\deqn{\beta_{u,v} \sim \text{N}(\phi \beta_{u,v-1}, \tau^2), \quad v > 1}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{\phi} is the damping coefficient;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the 'along' variable of the interaction; and
\item \eqn{u} denotes position within the 'by' variable(s) of the interaction.
}

Coefficient \eqn{\phi} is constrained
to lie between \code{min} and \code{max}.
Its prior distribution is

\deqn{\phi = (\mathtt{max} - \mathtt{min}) \phi' - \mathtt{min}}

where

\deqn{\phi' \sim \text{Beta}(\mathtt{shape1}, \mathtt{shape2}).}

Standard deviation \eqn{\tau}
has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \mathtt{s}^2),}
where \code{s} is provided by the user.

\code{DRW()} has the same basic structure as \code{\link[=AR1]{AR1()}}. However,
in \code{DRW()}, \eqn{\tau} controls the variance of the innovations,
but in \code{\link[=AR1]{AR1()}} \eqn{\tau} controls the marginal
variance of each \eqn{\beta_j} or \eqn{\beta_{u,v}}.
}

\section{Constraints}{


\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The specification of
constraints is likely to change in future versions of \pkg{bage}.

With some combinations of terms and priors, the values of
the intercept, main effects, and interactions are
are only weakly identified.
For instance, it may be possible to increase the value of the
intercept and reduce the value of the remaining terms in
the model with no effect on predicted rates and only a tiny
effect on prior probabilities. This weak identifiability is
typically harmless. However, in some applications, such as
when trying to obtain interpretable values
for main effects and interactions, it can be helpful to increase
identifiability through the use of constraints, specified through the
\code{con} argument.

Current options for \code{con} are:
\itemize{
\item \code{"none"} No constraints. The default.
\item \code{"by"} Only used in interaction terms that include 'along' and
'by' dimensions. Within each value of the 'along'
dimension, terms across each 'by' dimension are constrained
to sum to 0.
}
}

\examples{
DRW()
DRW(min = 0, max = 1)
DRW(sd = 0)
}
\seealso{
\itemize{
\item \code{\link[=DRW2]{DRW2()}} Damped second-order random walk
\item \code{\link[=RW]{RW()}} Random walk, without damping
\item \code{\link[=RW2]{RW2()}} Second-order random walk, without damping
\item \code{\link[=RW_Seas]{RW_Seas()}} Random walk with seasonal effect
\item \code{\link[=AR]{AR()}} Autoregressive with order k
\item \code{\link[=AR1]{AR1()}} Autoregressive with order 1
\item \code{\link[=Sp]{Sp()}} Smoothing via splines
\item \code{\link[=SVD]{SVD()}} Smoothing over age using singular value decomposition
\item \link{priors} Overview of priors implemented in \pkg{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
