% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{AR}
\alias{AR}
\title{Autoregressive Prior}
\usage{
AR(
  n_coef = 2,
  s = 1,
  shape1 = 5,
  shape2 = 5,
  along = NULL,
  con = c("none", "by")
)
}
\arguments{
\item{n_coef}{Number of lagged terms in the
model, ie the order of the model. Default is \code{2}.}

\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{shape1, shape2}{Parameters for beta-distribution prior
for coefficients. Defaults are \code{5} and \code{5}.}

\item{along}{Name of the variable to be used
as the 'along' variable. Only used with
interactions.}

\item{con}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Constraints on parameters.
Current choices are \code{"none"} and \code{"by"}.
Default is \code{"none"}. See below for details.}
}
\value{
An object of class \code{"bage_prior_ar"}.
}
\description{
Use an autoregressive process to model
a main effect, or use multiple autoregressive
processes to model an interaction.
Typically used with time effects or with
interactions that involve time.
}
\details{
If \code{AR()} is used with an interaction, then
separate AR processes are constructed along
the 'along' variable, within each combination of the
'by' variables.

By default, the autoregressive processes
have order 2. Alternative choices can be
specified through the \code{n_coef} argument.

Argument \code{s} controls the size of innovations.
Smaller values for \code{s} tend to give smoother estimates.
}
\section{Mathematical details}{


When \code{AR()} is used with a main effect,

\deqn{\beta_j = \phi_1 \beta_{j-1} + \cdots + \phi_{\mathtt{n\_coef}} \beta_{j-\mathtt{n\_coef}} + \epsilon_j}
\deqn{\epsilon_j \sim \text{N}(0, \omega^2),}

and when it is used with an interaction,

\deqn{\beta_{u,v} = \phi_1 \beta_{u,v-1} + \cdots + \phi_{\mathtt{n\_coef}} \beta_{u,v-\mathtt{n\_coef}} + \epsilon_{u,v}}
\deqn{\epsilon_{u,v} \sim \text{N}(0, \omega^2),}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the 'along' variable of the interaction; and
\item \eqn{u} denotes position within the 'by' variable(s) of the interaction.
}

Internally, \code{AR()} derives a value for \eqn{\omega} that
gives every element of \eqn{\beta} a marginal
variance of \eqn{\tau^2}. Parameter \eqn{\tau}
has a half-normal prior

\deqn{\tau \sim \text{N}^+(0, \mathtt{s}^2).}

The correlation coefficients \eqn{\phi_1, \cdots, \phi_{\mathtt{n\_coef}}}
each have prior

\deqn{\phi_k \sim \text{Beta}(\mathtt{shape1}, \mathtt{shape2}).}
}

\section{Constraints}{


\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The specification of
constraints is likely to change in future versions of \pkg{bage}.

With some combinations of terms and priors, the values of
the intercept, main effects, and interactions are
are only weakly identified.
For instance, it may be possible to increase the value of the
intercept and reduce the value of the remaining terms in
the model with no effect on predicted rates and only a tiny
effect on prior probabilities. This weak identifiability is
typically harmless. However, in some applications, such as
when trying to obtain interpretable values
for main effects and interactions, it can be helpful to increase
identifiability through the use of constraints, specified through the
\code{con} argument.

Current options for \code{con} are:
\itemize{
\item \code{"none"} No constraints. The default.
\item \code{"by"} Only used in interaction terms that include 'along' and
'by' dimensions. Within each value of the 'along'
dimension, terms across each 'by' dimension are constrained
to sum to 0.
}
}

\examples{
AR(n_coef = 3)
AR(n_coef = 3, s = 2.4)
AR(along = "cohort")
}
\references{
\itemize{
\item \code{AR()} is based on the TMB function
\href{http://kaskr.github.io/adcomp/classdensity_1_1ARk__t.html#details}{ARk}
}
}
\seealso{
\itemize{
\item \code{\link[=AR1]{AR1()}} Special case of \code{AR()}. Can be more
numerically stable than higher-order models.
\item \code{\link[=Lin_AR]{Lin_AR()}}, \code{\link[=Lin_AR1]{Lin_AR1()}} Straight line with AR errors
\item \link{priors} Overview of priors implemented in \pkg{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
