% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_text_splice}
\alias{am_text_splice}
\title{Splice text in a text object}
\usage{
am_text_splice(text_obj, pos, del_count, text)
}
\arguments{
\item{text_obj}{An Automerge text object ID}

\item{pos}{Character position to start splice (0-based inter-character position)}

\item{del_count}{Number of characters to delete (counts Unicode code points)}

\item{text}{Text to insert}
}
\value{
The text object \code{text_obj} (invisibly)
}
\description{
Insert or delete characters in a text object. This is the primary way to
edit text CRDT objects.
}
\section{Indexing Convention}{

\strong{Text positions use 0-based indexing} (unlike list indices which are
1-based). This is because positions specify locations \strong{between} characters,
not the characters themselves:
\itemize{
\item Position 0 = before the first character
\item Position 1 = between 1st and 2nd characters
\item Position 5 = after the 5th character
}

For the text "Hello":
\preformatted{
  H e l l o
 0 1 2 3 4 5  <- positions (0-based, between characters)
}

Positions count Unicode code points (characters), not bytes. The word
"Français" counts as 8 characters, matching R's \code{nchar()} behavior.
}

\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "doc", am_text("Hello"))
text_obj <- am_get(doc, AM_ROOT, "doc")
text_obj

# Insert " World" at position 5 (after "Hello")
am_text_splice(text_obj, 5, 0, " World")

# Get the full text
am_text_content(text_obj)  # "Hello World"

# Works naturally with multibyte characters
am_put(doc, AM_ROOT, "greet", am_text(""))
text_obj2 <- am_get(doc, AM_ROOT, "greet")
am_text_splice(text_obj2, 0, 0, "Column café")
# Position 11 is after "café" (character index, not bytes)
am_text_splice(text_obj2, 11, 0, "!")
am_text_content(text_obj2)  # "Column café!"

am_close(doc)

}
