% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_get_changes}
\alias{am_get_changes}
\title{Get changes since specified heads}
\usage{
am_get_changes(doc, heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{heads}{A list of raw vectors (change hashes) returned by \code{am_get_heads()},
or \code{NULL} to get all changes.}
}
\value{
A list of \code{am_change} objects.
}
\description{
Returns all changes that have been made to the document since the specified
heads. If \code{heads} is \code{NULL}, returns all changes in the document's history.
}
\details{
Changes are returned as \code{am_change} objects that can be inspected with
\code{\link[=am_change_hash]{am_change_hash()}}, \code{\link[=am_change_message]{am_change_message()}}, etc., serialized with
\code{\link[=am_change_to_bytes]{am_change_to_bytes()}}, or applied to other documents using
\code{\link[=am_apply_changes]{am_apply_changes()}}.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "x", 1)
am_commit(doc)

# Get all changes
all_changes <- am_get_changes(doc)
all_changes

am_close(doc)

}
