% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsis.R
\name{search_lunar_apsis}
\alias{search_lunar_apsis}
\title{Search for lunar apsis events}
\usage{
search_lunar_apsis(start_time)
}
\arguments{
\item{start_time}{A \code{POSIXct} datetime object indicating when to start the search.}
}
\value{
A list containing:
\describe{
\item{time}{A \code{POSIXct} datetime of the next lunar apsis.}
\item{kind}{Integer code: 0 for perigee (APSIS_PERICENTER), 1 for apogee (APSIS_APOCENTER).}
\item{dist_au}{Distance in astronomical units.}
\item{dist_km}{Distance in kilometers.}
}
}
\description{
Finds the date and time of the Moon's closest distance (perigee) or farthest
distance (apogee) with respect to the Earth after a given start time.
}
\details{
The closest point is called \emph{perigee} and the farthest point is called \emph{apogee}.
The word \emph{apsis} refers to either event.

To iterate through consecutive alternating perigee and apogee events, call
\code{search_lunar_apsis()} once, then use the return value to call
\code{next_lunar_apsis()}. After that, keep feeding the previous return value from
\code{next_lunar_apsis()} into another call of \code{next_lunar_apsis()} as many times
as desired.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
apsis <- search_lunar_apsis(start)
apsis$time
apsis$kind
}
