% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_sun_position}
\alias{astro_sun_position}
\title{Sun's position in ecliptic coordinates}
\usage{
astro_sun_position(time)
}
\arguments{
\item{time}{A \code{POSIXct} object representing the date and time.}
}
\value{
A list containing:
\describe{
\item{elon}{Ecliptic longitude in degrees.}
\item{elat}{Ecliptic latitude in degrees.}
\item{vec}{A list with Cartesian coordinates:
\describe{
\item{x}{X-coordinate in AU.}
\item{y}{Y-coordinate in AU.}
\item{z}{Z-coordinate in AU.}
\item{t}{Time as \code{POSIXct}.}
}
}
}
}
\description{
Calculates the geocentric ecliptic coordinates of the Sun.
The returned coordinates are based on the true equinox of date
(the instantaneous intersection of the Earth's equatorial plane and
the ecliptic plane at the given time).
}
\details{
This function accounts for light travel time from the Sun and corrects
for precession and nutation of the Earth's axis.
}
\examples{
time <- as.POSIXct("2025-03-20 09:00:00", tz = "UTC")
astro_sun_position(time)
}
