% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_EQD_ECL}
\alias{astro_rotation_EQD_ECL}
\title{Rotation Matrix from Equatorial of-Date to J2000 Ecliptic}
\usage{
astro_rotation_EQD_ECL(time)
}
\arguments{
\item{time}{A POSIXct object representing the date and time.}
}
\value{
A rotation matrix that converts EQD to ECL.
}
\description{
Calculates a rotation matrix from equatorial of-date (EQD) to J2000 mean
ecliptic (ECL).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: EQD = equatorial system, using equator of date.

\strong{Target}: ECL = ecliptic system, using equator at J2000 epoch.
}
\examples{
astro_rotation_EQD_ECL(Sys.time())

}
