% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_visualiser.R
\name{visualise_project}
\alias{visualise_project}
\title{Visualize Project}
\usage{
visualise_project(
  project_path,
  foo_path = "R",
  test_path = NULL,
  exclude_files = NULL,
  exclude_dirs = NULL,
  run_coverage = FALSE,
  color_no_test = c(background = "#fad1d0", border = "#9c0000", highlight = "#9c0000"),
  color_with_test = c(background = "#e6ffe6", border = "#65a765", highlight = "#65a765"),
  color_mod_coverage = c(background = "#FFD580", border = "#E49B0F", highlight =
    "#E49B0F"),
  moderate_coverage_range = c(0.2, 0.8),
  print_isolated_foo = FALSE,
  show_in_shiny = FALSE,
  network_title = "Function Network",
  scale_node_size_by_degree = TRUE
)
}
\arguments{
\item{project_path}{Path to the project folder.}

\item{foo_path}{Path to the folder containing foo functions.}

\item{test_path}{Path to the folder containing test functions.}

\item{exclude_files}{A regular expression for files to NOT process (basename)}

\item{exclude_dirs}{A regular expression for directories to NOT process (dirname)}

\item{run_coverage}{Boolean determining whether to run coverage assessment}

\item{color_no_test}{named vector with hexcodes for background, border and highlight}

\item{color_with_test}{named vector with hexcodes for background, border and highlight}

\item{color_mod_coverage}{named vector with hexcodes for background, border and highlight where coverage moderate}

\item{moderate_coverage_range}{vector of two values giving range defined as moderate coverage.}

\item{print_isolated_foo}{Print the isolated functions to the console (default false)}

\item{show_in_shiny}{logical scalar indicating whether to prepare/deploy the
network using a built in shiny app. Default is \code{FALSE}.}

\item{network_title}{title of the network plot.}

\item{scale_node_size_by_degree}{Scale the node size by the degree centrality of the node.}
}
\value{
A visNetwork object representing the network plot of function dependencies.
}
\description{
Visualize the dependencies between functions in a project using a network plot.
}
\examples{
\donttest{
# Example takes more than 5 seconds to run
# Visualize project dependencies in HTML
if(require(testthat)) {
  folder_path <- assertHE_example("example_project")
  visualise_project(
    project_path = folder_path,
    foo_path = "R",
    test_path = "tests/testthat",
    run_coverage = TRUE
  )
}

# Visualize project dependencies in shiny
if(interactive()) {
  visualise_project(
    project_path = folder_path,
    foo_path = "R",
    test_path = "tests/testthat",
    run_coverage = TRUE,
    show_in_shiny = TRUE
  )
}
}
}
