% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digestibility.R
\name{adc_ingr}
\alias{adc_ingr}
\title{ADC of a feed ingredient (ADCingr)}
\usage{
adc_ingr(
  adc_test,
  adc_ref,
  nut_ref,
  nut_ingr,
  dm_ref = 1,
  dm_ingr = 1,
  incl_ingr = 0.3
)
}
\arguments{
\item{adc_test}{a numeric value in the interval [0,1] that represents the
Apparent Digestibility Coefficient (ADC) of the diet that contains the
ingredient to be tested.}

\item{adc_ref}{a numeric value in the interval [0,1] that represents the
Apparent Digestibility Coefficient (ADC) of the reference diet without the
ingredient to be tested.}

\item{nut_ref}{a numeric value in the interval [0,1] that represents the
inclusion rate of the nutrient in the reference diet.}

\item{nut_ingr}{a numeric value in the interval [0,1] that represents the
inclusion rate of the nutrient in the test diet for which the Apparent
Digestibility Coefficient (ADC) of the nutrient in the ingredient will be
calculated.}

\item{dm_ref}{a numeric value in the interval [0,1] (default: 1) that 
represents the dry matter content of the reference diet.}

\item{dm_ingr}{a numeric value in the interval [0,1] (default: 1) that
represents the dry matter content of the tested feed ingredient.}

\item{incl_ingr}{a numeric value in the interval [0,1] (default: 0.3) that 
represents the inclusion rate of the ingredient in the test diet for which 
the Apparent Digestibility Coefficient (ADC) of the nutrient in an 
ingredient will be calculated.}
}
\value{
returns a single numeric value in the interval [0, 1], which is the
relative ADC for the diet. If the value is not within the interval, an
additional warning is returned.
}
\description{
Function to calculate the Apparent Digestibility Coefficient of a nutrient
contained in a feed ingredient of a compound diet. The calculation of the
ADCingr is based on equation 4 proposed by Bureau & Hua (2006).
}
\examples{
# Example from Bureau et al. (1999) - Blood meal 2

# reference feed dry matter: 0.928 (92.8\%)
# reference feed nutrient mass frac.: 0.45 (45\%)
# reference feed apparent digestibility coef.: 0.923 (92.3\%)
# test feed apparent digestibility coef.: 0.902 (90.2\%)
# test ingredient dry matter: 0.895 (89.5\%)
# test ingredient nutrient mass frac.: 0.846 (84.6\%)

adc_ingr(adc_ref = 0.923, 
         nut_ref = 0.45, 
         dm_ref = 0.928,
         adc_test = 0.902, 
         nut_ingr = 0.846,
         dm_ingr = 0.895)

}
\references{
Bureau, D. P., & Hua, K. (2006): Letter to the Editor of
Aquaculture. Aquaculture, 252, p.103–105.

Bureau, D. P., Harris, A. M., & Cho, C. Y. (1999): Apparent 
digestibility of rendered animal protein ingredients for rainbow trout 
(Oncorhynchus mykiss). Aquaculture 180, p.345-358.
}
\author{
Anıl Axel Tellbüscher
}
