% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{anki_learning_efficiency}
\alias{anki_learning_efficiency}
\title{Analyze learning efficiency}
\usage{
anki_learning_efficiency(
  path = NULL,
  profile = NULL,
  days = 30,
  by_deck = FALSE
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{days}{Number of days to analyze (default 30, NULL for all)}

\item{by_deck}{If TRUE, calculate efficiency per deck}
}
\value{
A tibble with efficiency metrics
}
\description{
Calculate how much "real learning" is happening vs time spent on failed reviews.
Measures the ratio of successful retention to total study time.
}
\examples{
\dontrun{
eff <- anki_learning_efficiency()
eff <- anki_learning_efficiency(days = 90, by_deck = TRUE)
}
}
