% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries_enhanced.R
\name{anki_forecast_monte_carlo}
\alias{anki_forecast_monte_carlo}
\title{Monte Carlo Forecasting}
\usage{
anki_forecast_monte_carlo(
  path = NULL,
  profile = NULL,
  days_ahead = 30,
  n_sim = 1000,
  method = "weekday",
  block_size = 7,
  include_trend = TRUE,
  seed = NULL
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{days_ahead}{Number of days to forecast (default 30)}

\item{n_sim}{Number of simulations (default 1000)}

\item{method}{Bootstrap method: "weekday" (preserves day-of-week), "block" (preserves sequences), "simple" (iid sampling)}

\item{block_size}{Block size for block bootstrap (default 7)}

\item{include_trend}{Whether to include trend component (default TRUE)}

\item{seed}{Random seed for reproducibility (NULL for random)}
}
\value{
A list with forecast distribution, summary statistics, and simulation data
}
\description{
Forecast future reviews using Monte Carlo simulation with bootstrapping.
Unlike statistical methods (ARIMA, Holt-Winters), this approach:
\itemize{
\item Makes no distributional assumptions
\item Preserves day-of-week patterns naturally
\item Handles irregular study habits (missed days, catch-up sessions)
\item Provides empirical confidence intervals
}
}
\examples{
\dontrun{
mc <- anki_forecast_monte_carlo(days_ahead = 30, n_sim = 1000)

# Summary
mc$summary

# Probability of >100 reviews on day 7
mc$prob_above(day = 7, threshold = 100)

# Full simulation matrix
dim(mc$simulations)  # n_sim x days_ahead
}
}
