% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decontaminated_dist.R
\name{plot.decontaminated_density}
\alias{plot.decontaminated_density}
\title{Plot method for object of class \code{decontaminated_density}}
\usage{
\method{plot}{decontaminated_density}(x, x_val = NULL, add_plot = FALSE, offset = 0, bar_width = 0.3, ...)
}
\arguments{
\item{x}{An object of class \code{decontaminated_density} (see ?decontaminated_density).}

\item{x_val}{Values at which to evaluate the decontaminated density.}

\item{add_plot}{Boolean, TRUE when a new plot is added to the existing one.}

\item{offset}{Numeric. Position of the bars relative to the labels on the x-axis.}

\item{bar_width}{Width of bars to be plotted.}

\item{...}{Arguments to be passed to generic method \code{plot}, such as graphical parameters (see ?par).}
}
\value{
The plot of the decontaminated density if one sample is provided, or the comparison of decontaminated
densities plotted on the same graph in the case of multiple samples.
}
\description{
Plot the decontaminated density of the unknown component from some admixture model, after inversion of the admixture
cumulative distribution functions.
}
\details{
The decontaminated density is obtained by inverting the admixture density, given by l = p*f + (1-p)*g, to isolate the
unknown component f after having estimated p and l.
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
