% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{replace_symbol_in_expr}
\alias{replace_symbol_in_expr}
\title{Replace Symbols in an Expression}
\usage{
replace_symbol_in_expr(expression, target, replace)
}
\arguments{
\item{expression}{Expression

\describe{
\item{Permitted values}{a quoted expression, e.g., created by \code{expr()}}
\item{Default value}{none}
}}

\item{target}{Target symbol

\describe{
\item{Permitted values}{an unquoted symbol, e.g., \code{AVAL}}
\item{Default value}{none}
}}

\item{replace}{Replacing symbol

\describe{
\item{Permitted values}{an unquoted symbol, e.g., \code{AVAL}}
\item{Default value}{none}
}}
}
\value{
The expression where every occurrence of the symbol \code{target} is
replaced by \code{replace}
}
\description{
Replace symbols in an expression
}
\examples{
library(rlang)

replace_symbol_in_expr(expr(AVAL), target = AVAL, replace = AVAL.join)
replace_symbol_in_expr(expr(AVALC), target = AVAL, replace = AVAL.join)
replace_symbol_in_expr(expr(desc(AVAL)), target = AVAL, replace = AVAL.join)
replace_symbol_in_expr(expr(if_else(AVAL > 0, AVAL, NA)), AVAL, AVAL.join)
}
\seealso{
Helpers for working with Quosures:
\code{\link{add_suffix_to_vars}()},
\code{\link{expr_c}()},
\code{\link{replace_values_by_names}()}
}
\author{
Stefan Bundfuss
}
\concept{quo}
\keyword{quo}
