% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_date_vector}
\alias{assert_date_vector}
\title{Is an object a date or datetime vector?}
\usage{
assert_date_vector(
  arg,
  optional = FALSE,
  arg_name = rlang::caller_arg(arg),
  message = NULL,
  class = "assert_date_vector",
  call = parent.frame()
)
}
\arguments{
\item{arg}{The function argument to be checked

\describe{
\item{Default value}{none}
}}

\item{optional}{Is the checked argument optional? If set to \code{FALSE}
and \code{arg} is \code{NULL} then the function \code{assert_date_vector} exits early and throw and error.

\describe{
\item{Default value}{\code{FALSE}}
}}

\item{arg_name}{string indicating the label/symbol of the object being checked.

\describe{
\item{Default value}{\code{rlang::caller_arg(arg)}}
}}

\item{message}{string passed to \code{cli::cli_abort(message)}.
When \code{NULL}, default messaging is used (see examples for default messages).
\code{"{arg_name}"} can be used in messaging.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{class}{Subclass of the condition.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
The function returns an error if \code{arg} is missing, or not a date or datetime variable
but otherwise returns an invisible output.
}
\description{
Check if an object/vector is a date or datetime variable without needing a dataset as input
}
\examples{
example_fun <- function(arg) {
  assert_date_vector(arg)
}

example_fun(
  as.Date("2022-01-30", tz = "UTC")
)
try(example_fun("1993-07-14"))
}
\seealso{
Checks for valid input and returns warning or errors messages:
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_expr}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
