% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arxiv_open.R
\name{arxiv_open}
\alias{arxiv_open}
\title{Open abstract for results of arXiv search}
\usage{
arxiv_open(search_results, limit = 20)
}
\arguments{
\item{search_results}{Data frame of search results, as returned from \code{\link[=arxiv_search]{arxiv_search()}}.}

\item{limit}{Maximum number of abstracts to open in one call.}
}
\value{
(Invisibly) Vector of character strings with URLs of
abstracts opened.
}
\description{
Open, in web browser, the abstract pages for each of set of arXiv search results.
}
\details{
There is a delay between calls to
\code{\link[utils:browseURL]{utils::browseURL()}}, with the amount taken from the R
option \code{"aRxiv_delay"} (in seconds); if missing, the default
is 3 sec.
}
\examples{
\donttest{
if(interactive()) {
    z <- arxiv_search('au:"Peter Hall" AND ti:deconvolution')
    arxiv_open(z)
} }

}
\seealso{
\code{\link[=arxiv_search]{arxiv_search()}}
}
