% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSerfling_predict.R
\name{aSerfling_predict}
\alias{aSerfling_predict}
\title{Apply Adjusted Serfling Model to Subsequent Time Periods}
\usage{
aSerfling_predict(sf, df_test)
}
\arguments{
\item{sf}{Model object from \code{\link{aSerfling}} (must contain \code{best_fit},
\code{output}, and \code{cycles} components)}

\item{df_test}{New data frame with identical structure to training data, containing
subsequent time points. Must include the response variable column used
in original modeling.}
}
\value{
A data frame containing warning results. The value of the warning column is 1 for warning and 0 for no warning.
}
\description{
Projects an existing Serfling model onto new temporally contiguous data to detect
epidemic signals. Requires test data to immediately follow training data chronologically
to maintain periodicity.
}
\details{
This function extends the surveillance capability of an established \code{aSerfling} model by:
\itemize{
  \item Automatically generating time indices continuing from the training set
  \item Preserving all terms from the original model fit
  \item Calculating prediction intervals using the trained coefficients
  \item Flagging values exceeding the 95\% upper prediction bound as warnings
}

Critical requirements:
\enumerate{
  \item Test data must maintain the same time resolution (weekly/monthly) as training data
  \item The first test observation must be the immediate next time point after the last training observation
  \item Column names and cycle parameters must match the original model specification
}
}
\examples{
data(sample_ili)

## Split into sequential training/test sets
df_train <- sample_ili[1:150,]
df_test <- sample_ili[151:200,]

## modeling
sf <- aSerfling(df_train, 'case', cycles = c(52, 26))

## apply the model to test set
pre <- aSerfling_predict(sf, df_test)

## visualize alerts
plot(pre$date, pre$case, type = "l")
points(pre$date[pre$warning == 1],
       pre$case[pre$warning == 1], col = "red")

}
\references{
Wang X, Wu S, MacIntyre CR, et al. Using an adjusted Serfling regression model to improve the early warning at the arrival of peak timing of influenza in Beijing. PLoS One, 2015,10(3):e0119923.
}
