% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_sh.R
\name{stability_sh}
\alias{stability_sh}
\title{Structural stability of a VAR(p)}
\usage{
stability_sh(
  x,
  type = c("OLS-CUSUM", "Rec-CUSUM", "Rec-MOSUM", "OLS-MOSUM", "RE", "ME", "Score-CUSUM",
    "Score-MOSUM", "fluctuation"),
  h = 0.15,
  dynamic = FALSE,
  rescale = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class "varshrinkest"}

\item{type, h, dynamic, rescale, ...}{Other arguments to
\code{strucchange::efp()}}
}
\value{
A list with class attribute "varstabil" which contains the following
elements: \code{stability}, \code{endog}, \code{K}. The \code{stability} is
a list of \code{strucchange::efp()} outputs.
}
\description{
Computes empirical fluctuation processes for VAR estimates.
Utilizes \code{strucchange::efp()} for the VAR estimates of each time series
variable.
}
\details{
A variant of \code{vars::stability()} for an object of class "varshrinkest".
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
stabil <- stability_sh(estim)
plot(stabil)
}
\seealso{
\code{\link[vars]{stability}}
}
