% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_multiv_ridge.R
\name{lm_multiv_ridge}
\alias{lm_multiv_ridge}
\title{Multivariate Ridge Regression}
\usage{
lm_multiv_ridge(Y, X, lambda = 0, do_scale = FALSE)
}
\arguments{
\item{Y}{An N x K matrix of dependent variables.}

\item{X}{An N x M matrix of regressors.}

\item{lambda}{Numeric vector of lambda values}

\item{do_scale}{If true, X is centered and scaled, and Y is centered.}
}
\value{
A list object with the components: 1) Psi - A list of
estimated \eqn{\mathbf{\Psi}} matrices, 2) lambda - A vector of
\eqn{\lambda} values, 3) GCV - A vector of GCV values
}
\description{
Estimate regression coefficients by using ridge regression.
}
\details{
Consider the multivariate regression:
\deqn{\mathbf{Y} = \mathbf{X \Psi} + \mathbf{e}.}
\eqn{\mathbf{\Psi}} is a M-by-K matrix of regression coefficients.
The ridge regression estimate for the coefficients is
\deqn{\mathbf{\Psi} = (\mathbf{X'X} + \lambda \mathbf{I})^{-1}
\mathbf{X'Y}.}
}
\references{
G. H. Golub, M. Heath, G. Wahba (1979).
Generalized cross-validation as a method for choosing a good
ridge parameter. Technometrics 21(2), 215-223. doi: 10.2307/1268518
}
