% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convPsi2varresult.R
\name{convPsi2varresult}
\alias{convPsi2varresult}
\title{Convert format for VAR coefficients from Psi to varresult}
\usage{
convPsi2varresult(
  Psi,
  Y,
  X,
  lambda0,
  type = c("const", "trend", "both", "none"),
  ybar = NULL,
  xbar = NULL,
  Q_values = NULL,
  callstr = ""
)
}
\arguments{
\item{Psi}{An M-by-K matrix of VAR coefficients}

\item{Y}{An N-by-K data matrix of dependent variables}

\item{X}{An N-by-M data matrix of regressors}

\item{lambda0}{A rescaled shrinkage intensity parameter, based on which the
effective number of parameters is computed by
\deqn{Trace(X(X'X + \lambda_0*I)^{-1} X')}}

\item{type}{Type of deterministic variables in the VAR estimation problem.
Either of "const", "trend", "both", or "none".}

\item{ybar, xbar}{NULL if Y and X are not centered. Mean vectors if Y and X
had been centered. If Y and X had been centered (ybar and xbar are not NULL)
and type is "const" or "both", then the coefficients for the constant term
is computed and concatenated to the coefficients.}

\item{Q_values}{Nonnegative weight vector of length N. Default is NULL.
Take weights on rows (samples) of Y and X by sqrt(Q).}

\item{callstr}{The call to VARshrink().}
}
\value{
A list object with objects of class c("shrinklm", "lm").
Each "shrinklm" object has components: coefficients, residuals,
fitted.values, rank, df.residual, lambda0, call, terms, svd
}
\description{
Convert a matrix of VAR coefficients estimated by a shrinkage method
into a list of "shrinklm" object, where the class "shrinklm" inherits the
class "lm".
}
\details{
Consider VAR(p) model:
\deqn{y_t = A_1 y_{t-1} + ... + A_p y_{t-p} + C d_t + e_t.}
It can be written in the matrix form:
\deqn{Y = X \Psi + E,}
where \eqn{\Psi} is a concatenated M-by-K matrix,
\eqn{\Psi = (A_1, ..., A_p, C)^T}.
It can be written in the multiple linear regression form of a VAR(p) model:
\deqn{y_j = X \psi_j + e_j, \quad j=1,...,K,}
where \eqn{y_j}, \eqn{\psi_j}, and \eqn{e_j} are the j-th column vectors of
Y, \eqn{\Psi}, and E, respectively.
This function converts \eqn{\Psi} into a list of "shrinklm" objects, where
each "shrinklm" object contains the length-M vector \eqn{\psi_j} as
coefficients.

Considering that each coefficient vector \eqn{\psi_j} is estimated by a
shrinkage method, the effective number of parameters, \eqn{k_{eff}}, is
computed as:
\deqn{k_{eff} = Trace(X (X^T X + \lambda_0 * I)^{-1} X^T).}
Then, the degree of freedom of residuals is computed as:
\deqn{df.residual = N - k_{eff},}
where N is the number of rows of data matrices Y and X.
}
