% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myerson_unions.R
\name{myerson_unions}
\alias{myerson_unions}
\title{Myerson value with a priori unions}
\usage{
myerson_unions(
  characteristic_func,
  n_players = 0,
  unions,
  graph_edges,
  method = "exact",
  n_rep = 10000,
  echo = TRUE
)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players. It can be provided as a vector or as a function.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}

\item{unions}{List of vectors indicating the a priori unions between the
players.}

\item{graph_edges}{Edges of the communication graph of the game. It must be
a \code{list} of pairs indicating the connected players.}

\item{method}{Method used to  calculate the Myerson value. Valid methods are:
\code{exact} for the exact calculation or \code{appro} for approximated polynomial
calculation based on sampling proposed.}

\item{n_rep}{Only used if \code{method} is \code{appro}. The number of
iterations to perform in the approximated calculation.}

\item{echo}{Only used if \code{method} is \code{appro}. Show progress of the
approximated calculation.}
}
\value{
The Myerson value for each player.
}
\description{
Calculate the Myerson value in a communication game with a priori unions.
}
\examples{
v <- c(
  0, 0, 0, 0,
  1, 1, 1, 0, 0, 0,
  1, 1, 1, 1,
  1
)
graph_edges <- list(c(2,3),c(3,1),c(1,4))
unions <- list(c(2,3),c(1),c(4))
myerson_unions(v, unions = unions, graph_edges = graph_edges, method = "exact")
myerson_unions(v, unions = unions, graph_edges = graph_edges, method = "appro", n_rep = 2000)

}
