% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick-get.R
\name{spod_quick_get_zones}
\alias{spod_quick_get_zones}
\title{Get the municipalities geometries}
\usage{
spod_quick_get_zones(zones = "municipalities")
}
\arguments{
\item{zones}{A character string specifying the zones to retrieve. Valid values are "municipalities", "muni", "municip", and "municipios". Defaults to "municipalities".}
}
\value{
A \code{sf} object with the municipalities geometries to match with the data retrieved with \code{\link[=spod_quick_get_od]{spod_quick_get_od()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function fetches the municipalities (for now this is the  only option) geometries from the mapas-movilidad website and returns a \code{sf} object with the municipalities geometries. This is intended for use with the flows data retrieved by the \code{\link[=spod_quick_get_od]{spod_quick_get_od()}} function. An interactive web map with this data is available at \url{https://mapas-movilidad.transportes.gob.es/}. These municipality geometries only include Spanish municipalities (and not the NUTS3 regions in Portugal and France) and do not contain extra columns that you can get with the \code{\link[=spod_get_zones]{spod_get_zones()}} function. The function caches the retrieved geometries in memory of the current R session to reduce the number of requests to the mapas-movilidad website.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
municipalities_sf <- spod_quick_get_zones()
}
\dontshow{\}) # examplesIf}
}
