% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{ddcopula}
\alias{ddcopula}
\title{Joint probability under a discrete bivariate copula}
\usage{
ddcopula(d1, d2, p1, p2, Copula, log = FALSE)
}
\arguments{
\item{d1, d2}{Marginal p.m.f. values at the observed points, \strong{not} on log-scale.}

\item{p1, p2}{Marginal CDF values at the observed points.}

\item{Copula}{A function of two arguments returning the copula CDF.}

\item{log}{Logical; if \code{TRUE}, return the log joint density. In this case,
\code{d1} and \code{d2} must be on the log scale.}
}
\value{
Joint probability (or log-probability) under chosen copula
}
\description{
Computes the joint probability mass function of two \strong{discrete} margins
combined with a copula CDF.
}
\details{
The joint probability mass function for two discrete margins is
\deqn{
\Pr(Y_1 = y_1, Y_2 = y_2) =
C(F_1(y_1), F_2(y_2))
- C(F_1(y_1-1), F_2(y_2))
- C(F_1(y_1), F_2(y_2-1))
+ C(F_1(y_1-1), F_2(y_2-1)),
}
where \eqn{F_i} are the marginal CDFs, and \eqn{C} is the copula CDF.

Available copula CDF constructors are:
\itemize{
\item \code{\link{Cclayton}} (Clayton copula)
\item \code{\link{Cgumbel}} (Gumbel copula)
\item \code{\link{Cfrank}} (Frank copula)
}
}
\examples{
x <- c(3,5); y <- c(2,4)
d1 <- dpois(x, 4); d2 <- dpois(y, 3)
p1 <- ppois(x, 4); p2 <- ppois(y, 3)
ddcopula(d1, d2, p1, p2, Copula = Cclayton(2), log = FALSE)
}
\seealso{
\code{\link[=dcopula]{dcopula()}}, \code{\link[=dmvcopula]{dmvcopula()}}
}
