% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_distance_forest_matrix.R
\name{predict_distance_forest_matrix}
\alias{predict_distance_forest_matrix}
\title{Predict Distances Between Samples Based on a Survival Forest Fit (Data Supplied as Matrices)}
\usage{
predict_distance_forest_matrix(
  survival_forest,
  matrix_numeric,
  matrix_factor,
  missing = "omit"
)
}
\arguments{
\item{survival_forest}{a fitted survival forest}

\item{matrix_numeric}{numeric predictors, a numeric matrix. 
\code{matrix_numeric[i,j]} is the jth numeric predictor of the ith sample.
The best practice is to have the same column names in the training and testing dataset.}

\item{matrix_factor}{factor predictors, a character matrix. 
\code{matrix_factor[i,j]} is the jth predictor of the ith sample.
The best practice is to have the same column names in the training and testing dataset.}

\item{missing}{a character value that specifies the handling of missing data. 
If \code{missing=="omit"}, samples with missing values in the splitting variables will be discarded.
If \code{missing=="majority"}, samples with missing values in the splitting variables will be assigned to the majority node.
If \code{missing=="weighted"}, samples with missing values in the splitting variables will be weighted by the weights of branch nodes.
The best practice is to use the same method as the trained random forest.}
}
\value{
A list. 
\code{mean_distance} is the mean distance matrix. 
\code{sum_distance} is the matrix that sums the distances between samples. 
\code{sum_non_na} is the matrix of the number of non NA distances being averaged.
}
\description{
The function 
\code{predict_distance_forest_matrix} predicts distances between samples based on a survival forest fit.
}
\details{
Predict Distances Between Samples Based on a Survival Forest Fit (Data Supplied as Matrices)
(Works for raw matrices)
}
\examples{
\donttest{
library(survival)
a_survival_forest<-
  survival_forest_matrix(
    time=lung$time,
    event=lung$status==2,
    matrix_numeric=data.matrix(lung[,c(4,6:9),drop=FALSE]),
    matrix_factor=data.matrix(lung[,5,drop=FALSE]),
    nboot=20)
a_distance<-
  predict_distance_forest_matrix(
    a_survival_forest,
    matrix_numeric=data.matrix(lung[,c(4,6:9),drop=FALSE]),
    matrix_factor=data.matrix(lung[,5,drop=FALSE]))
}
}
