% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb.R
\name{tb}
\alias{tb}
\title{Frequency and Summary Tables}
\usage{
tb(
  data,
  ...,
  m = FALSE,
  d = 1,
  format = TRUE,
  style = "n_pct",
  style.rp = "{rp} ({lower} - {upper})",
  style.or = "{or} ({lower} - {upper})",
  test = FALSE,
  subset = NULL,
  strat = NULL,
  rp = FALSE,
  or = FALSE,
  ref = NULL,
  conf.level = 0.95,
  var.type = NULL,
  stat.cont = "median"
)
}
\arguments{
\item{data}{A data.frame or atomic vector.}

\item{...}{Variables to be tabulated. Accepts variable names and/or flags
(\code{m}, \code{p}, \code{row}, \code{col}, \code{rp}, \code{or}) for controlling output format.}

\item{m}{Logical. Include missing values (NA) in the table. Default: \code{FALSE}.}

\item{d}{Integer. Decimal places for percentages and statistics. Default: \code{1}.}

\item{format}{Logical. Render a formatted grid output. Default: \code{TRUE}.}

\item{style}{Character. Format for displaying counts and percentages.
Options: \code{"n_pct"} (default), \code{"pct_n"}, or a custom template with \code{{n}} and
\code{{p}} placeholders, e.g. \code{"{n} [{p}\%]"}.}

\item{style.rp}{Character. Format string for Prevalence Ratio.
Default: \code{"{rp} ({lower} - {upper})"}.}

\item{style.or}{Character. Format string for Odds Ratio.
Default: \code{"{or} ({lower} - {upper})"}.}

\item{test}{Logical or Character. Performs statistical test on 2x2+ tables.
\code{TRUE} for automatic selection, or one of \code{"chisq"}, \code{"fisher"}, \code{"mcnemar"}.}

\item{subset}{Logical expression for row filtering.}

\item{strat}{Variable for column stratification. Disables PR/OR calculations.}

\item{rp}{Logical. Calculate Prevalence Ratios (PR). Default: \code{FALSE}.}

\item{or}{Logical. Calculate Odds Ratios (OR). Default: \code{FALSE}.}

\item{ref}{Character or numeric. Reference level for PR/OR calculations.}

\item{conf.level}{Numeric. Confidence level for intervals (0-1). Default: \code{0.95}.}

\item{var.type}{Named character vector specifying variable types, e.g.
\code{c(age = "continuous")}.}

\item{stat.cont}{Character. \code{"mean"} (Mean/SD) or \code{"median"} (Median/IQR).
Default: \code{"median"}.}
}
\value{
An object of class \code{tb} (a matrix with attributes).
}
\description{
Creates comprehensive tables for categorical or continuous variables with formatting,
statistical tests, prevalence ratios (PR), odds ratios (OR), and column stratification.
}
