## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(SimplyAgree)

dat = data.frame(
  x = c(7, 8.3, 10.5, 9, 5.1, 8.2, 10.2, 10.3, 7.1, 5.9),
  y = c(7.9, 8.2, 9.6, 9, 6.5, 7.3, 10.2, 10.6, 6.3, 5.2)
)

## -----------------------------------------------------------------------------
dem1 = dem_reg(y ~ x,
               data = dat,
               error.ratio = 2,
               weighted = FALSE)
dem1

## -----------------------------------------------------------------------------
plot(dem1, interval = "confidence")

## -----------------------------------------------------------------------------
check(dem1)

## -----------------------------------------------------------------------------
library(deming)
data('ferritin')

head(ferritin)

## -----------------------------------------------------------------------------
dem2 = dem_reg(
  old.lot ~ new.lot,
  data = ferritin,
  weighted = FALSE
)
summary(dem2)

plot(dem2)

check(dem2)

## -----------------------------------------------------------------------------
dem3 = dem_reg(
  old.lot ~ new.lot,
  data = ferritin,
  weighted = TRUE
)
summary(dem3)

plot(dem3)

check(dem3)

## -----------------------------------------------------------------------------
# Create example data
pb_data <- data.frame(
  method1 = c(69.3, 27.1, 61.3, 50.8, 34.4, 92.3, 57.5, 45.5, 33.3, 60.9,
              56.3, 49.9, 89.7, 28.9, 96.3, 76.6, 83.2, 79.4, 51.7, 32.5,
              99.1, 14.2, 84.1, 48.8, 61.5, 84.9, 93.2, 73.8, 62.1, 98.6),
  method2 = c(69.1, 26.7, 61.4, 51.2, 34.7, 88.5, 57.9, 45.1, 33.4, 60.8,
              66.5, 48.2, 88.3, 29.3, 96.4, 77.1, 82.7, 78.9, 51.6, 28.8,
              98.4, 12.7, 83.6, 47.3, 61.2, 84.6, 92.1, 73.4, 61.9, 98.6)
)

# Fit Passing-Bablok regression
pb1 <- pb_reg(method2 ~ method1, data = pb_data)
pb1

## -----------------------------------------------------------------------------
summary(pb1)

## -----------------------------------------------------------------------------
plot(pb1)

## -----------------------------------------------------------------------------
check(pb1)

## -----------------------------------------------------------------------------
pb2 <- pb_reg(method2 ~ method1, 
              data = pb_data, 
              replicates = 999)
summary(pb2)

## -----------------------------------------------------------------------------
plot_joint(dem1, 
           ideal_slope = 1, 
           ideal_intercept = 0,
           show_intervals = TRUE)

## -----------------------------------------------------------------------------
plot_joint(pb2)

## -----------------------------------------------------------------------------
joint_test(dem1)

## -----------------------------------------------------------------------------
joint_test(pb2)

