% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExampleFXHedge.R
\name{ExampleFXHedge}
\alias{ExampleFXHedge}
\title{FX Example}
\usage{
ExampleFXHedge(
  JSON = FALSE,
  rwa_fx_cpty = NULL,
  rwa_cds_cpty = NULL,
  EAD_cds = NULL,
  hedging_approach = NULL,
  protection_percentage = NULL
)
}
\arguments{
\item{JSON}{(optional) if TRUE it returns a json string}

\item{rwa_fx_cpty}{(optional) The risk weight of the original counterparty}

\item{rwa_cds_cpty}{(optional) The risk weight of the hedging counterparty}

\item{EAD_cds}{(optional) The EAD of the hedging CDS contract}

\item{hedging_approach}{(optional) The hedging approach, can be 'Current', 'TechnicalAmendment' or 'CappedProtection'}

\item{protection_percentage}{(optional) if the hedging_approach is 'CappedProtection'}
}
\value{
The exposure at default
}
\description{
Calculates the Exposure at Default for the FX product type
}
\examples{
tree_fx_hedge = ExampleFXHedge(rwa_fx_cpty = 0.2, rwa_cds_cpty = 0.2, EAD_cds = 14,
 hedging_approach = "CappedProtection", protection_percentage = 0.5)
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm

Technical Amendment - Hedging of counterparty credit risk exposures
https://www.bis.org/bcbs/publ/d600.htm
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
