% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_idigbio.R
\name{get_idigbio}
\alias{get_idigbio}
\title{get_idigbio}
\usage{
get_idigbio(species = NULL, fields = "all", genus = NULL,
family = NULL, order = NULL, phylum = NULL, kingdom = NULL, country = NULL,
county = NULL, limit = NULL, offset = NULL, dir, filename = "idigbio_output",
save = FALSE, compress = FALSE, file.format = "csv", verbose = TRUE, ...)
}
\arguments{
\item{species}{(character) scientific name(s) of species to search for.
Default is \code{NULL}.}

\item{fields}{(character) fields to retrieve from iDigBio. Default is \code{"all"}.}

\item{genus}{(character) genus name for filtering results. Default is \code{NULL}.}

\item{family}{(character) family name for filtering results. Default is \code{NULL}.}

\item{order}{(character) order name for filtering results. Default is \code{NULL}.}

\item{phylum}{(character) phylum name for filtering results. Default is \code{NULL}.}

\item{kingdom}{(character) kingdom name for filtering results. Default is \code{NULL}.}

\item{country}{(character) country name for geographic filtering. Default is \code{NULL}.}

\item{county}{(character) county name for geographic filtering. Default is \code{NULL}.}

\item{limit}{(numeric) maximum number of records to retrieve. Default is
\code{NULL} (no limit).}

\item{offset}{(numeric) number of records to skip before starting retrieval.
Default is \code{NULL} (starts at 0).}

\item{dir}{(character) directory path where the file will be saved.
Required if \code{save = TRUE}.}

\item{filename}{(character) name of the output file without extension.
Default is \code{"idigbio_output"}.}

\item{save}{(logical) if \code{TRUE}, saves the results to a CSV file.
Default is \code{FALSE}.}

\item{compress}{(logical) if \code{TRUE} and \code{save = TRUE}, compresses the output
file as .csv.zip. Default is \code{FALSE}.}

\item{file.format}{(character) file format for saving output (\code{"csv"}, \code{"rds"}).
Default is \code{"csv"}}

\item{verbose}{(logical) if \code{TRUE}, prints messages about the progress and
the number of species being checked. Default is \code{TRUE}.}

\item{...}{additional arguments passed to \code{ridigbio::idig_search_records()}.}
}
\value{
A \code{data.frame} containing occurrence records from iDigBio with the requested
fields.
}
\description{
Downloads species occurrence records from the iDigBio (Integrated Digitized
Biocollections) database with flexible taxonomic and geographic filtering
options.
}
\examples{
\donttest{
## search for a single species
records_basic <- get_idigbio(species = "Arecaceae")

## search for multiple species
records_multiple <- get_idigbio(
  species = c("Araucaria angustifolia"),
  limit = 100)

## save results as a compressed RDS file
records_saved_rds <- get_idigbio(
  species = "Anacardiaceae",
  limit = 50,
  dir = tempdir(),
  filename = "anacardiaceae_records",
  save = TRUE,
  compress = TRUE,
  file.format = "rds")
}

}
