% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bien_here.R
\name{bien_here}
\alias{bien_here}
\title{Download species distribution information from BIEN}
\usage{
bien_here(
  data_dir,
  species,
  synonyms = NULL,
  overwrite = TRUE,
  progress_bar = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data_dir}{(character) directory to save the data downloaded from BIEN.}

\item{species}{(character) a vector of species names for which to retrieve
distribution information.}

\item{synonyms}{(data.frame) an optional data.frame containing synonyms of
the target species. The first column must contain the target species names,
and the second column their corresponding synonyms. Default is \code{NULL}.
See details for more information.}

\item{overwrite}{(logical) whether to overwrite existing files. Default is
\code{TRUE}.}

\item{progress_bar}{(logical) whether to display a progress bar during processing.
If TRUE, the 'pbapply' package must be installed. Default is \code{FALSE}.}

\item{verbose}{(logical) whether to display progress messages. Default is
\code{TRUE}.}
}
\value{
A data frame indicating whether the polygon(s) representing the species range
are available in BIEN.
If the range is available, a GeoPackage file (.gpkg) is saved in
\code{data_dir/bien}. The file name corresponds to the species name, with an
underscore (“_”) replacing the space between the genus and the specific
epithet.
}
\description{
This function downloads distribution information from the BIEN database,
required for filtering occurrence records using specialists' information via
the \code{flag_bien()} function.
}
\details{
This function uses the \code{BIEN::BIEN_ranges_load_species()} function to
retrieve polygons representing the distribution ranges of species available
in the BIEN database.

Because taxonomic information in BIEN may be outdated, you can optionally
provide a table of synonyms to broaden the search. The synonyms data.frame
should have the accepted species in the first column and their synonyms in
the second. See \code{RuHere::synonys} for an example.
}
\examples{
\donttest{
# Define a directory to save the data
data_dir <- tempdir() # Here, a temporary directory

# Download species distribution information from BIEN
bien_here(data_dir = data_dir, species = "Handroanthus serratifolius")
}
}
