% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robFScore2.R
\name{robFScore2}
\alias{robFScore2}
\title{General robust F-Beta Score}
\usage{
robFScore2(
  actual = NULL,
  predicted = NULL,
  TP = NULL,
  FN = NULL,
  FP = NULL,
  TN = NULL,
  d1 = 1,
  d0 = 0.1,
  c = 1
)
}
\arguments{
\item{actual}{A vector of actual values (1/0 or TRUE/FALSE)}

\item{predicted}{A vector of prediction values (1/0 or TRUE/FALSE)}

\item{TP}{Count of true positives (correctly predicted 1/TRUE)}

\item{FN}{Count of false negatives (predicted 0/FALSE, but actually 1/TRUE)}

\item{FP}{Count of false positives (predicted 1/TRUE, but actually 0/FALSE)}

\item{TN}{Count of true negatives (correctly predicted 0/FALSE)}

\item{d1}{Weight of recall in the harmonic mean (corresponds to beta squared)}

\item{d0}{Weight of the estimated true positive probability in the harmonic mean}

\item{c}{Additional parameter in numerator}
}
\value{
robust F-Beta Score with two additional parameters.
}
\description{
Compute a robust version of the F-Beta Score with two additional parameters.
}
\details{
Calculate the robust F-Beta Score \eqn{F_{rb}} with two additional parameters.
Provide either:
\itemize{
\item \code{actual} and \code{predicted} or
\item \code{TP}, \code{FN}, \code{FP} and \code{TN}.
}

If \eqn{d_1=\beta^2, d_0=c=0}, the robust F-Beta Score coincides with the F-Beta Score.
}
\examples{
actual <-    c(1,1,1,1,1,1,0,0,0,0)
predicted <- c(1,1,1,1,0,0,1,0,0,0)
robFScore2(actual, predicted, d0 = 0.1, c = 0.1)
robFScore2(TP=4, FN=2, FP=1, TN=3, d0 = 0.1, c = 1)

}
\references{
Holzmann, H., Klar, B. (2024). Robust performance metrics for imbalanced classification problems.
arXiv:2404.07661. \href{https://arxiv.org/abs/2404.07661}{LINK}
}
