% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{forest}
\alias{forest}
\title{Forest plot for a RoBMA object}
\usage{
forest(
  x,
  conditional = FALSE,
  plot_type = "base",
  output_scale = NULL,
  order = NULL,
  ...
)
}
\arguments{
\item{x}{a fitted RoBMA object}

\item{conditional}{whether conditional estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates. Note that both \code{"weightfunction"} and
\code{"PET-PEESE"} are always ignoring the other type of
publication bias adjustment.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{output_scale}{transform the effect sizes and the meta-analytic
effect size estimate to a different scale. Defaults to \code{NULL}
which returns the same scale as the model was estimated on.}

\item{order}{order of the studies. Defaults to \code{NULL} -
ordering as supplied to the fitting function. Studies
can be ordered either \code{"increasing"} or \code{"decreasing"} by
effect size, or by labels \code{"alphabetical"}.}

\item{...}{list of additional graphical arguments
to be passed to the plotting function. Supported arguments
are \code{lwd}, \code{lty}, \code{col}, \code{col.fill},
\code{xlab}, \code{ylab}, \code{main}, \code{xlim}, \code{ylim}
to adjust the line thickness, line type, line color, fill color,
x-label, y-label, title, x-axis range, and y-axis range
respectively.}
}
\value{
\code{forest} returns either \code{NULL} if \code{plot_type = "base"}
or an object object of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{forest} creates a forest plot for
a \code{"RoBMA"} object.
}
\examples{
\dontrun{
# using the example data from Anderson et al. 2010 and fitting the default model
# (note that the model can take a while to fit)
fit <- RoBMA(r = Anderson2010$r, n = Anderson2010$n, study_names = Anderson2010$labels)

### ggplot2 version of all of the plots can be obtained by adding 'model_type = "ggplot"
# the forest function creates a forest plot for a fitted RoBMA object, for example,
# the forest plot for the individual studies and the model-averaged effect size estimate
forest(fit)

# the conditional effect size estimate
forest(fit, conditional = TRUE)

# or transforming the effect size estimates to Fisher's z
forest(fit, output_scale = "fishers_z")
}

}
