% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WGEE.R
\name{WGEE}
\alias{WGEE}
\title{The Weigted Generalized Exponential-Exponential family}
\usage{
WGEE(mu.link = "log", sigma.link = "log", nu.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a WGEE distribution in the \code{gamlss()} function.
}
\description{
The Weigted Generalized Exponential-Exponential family
}
\details{
The Weigted Generalized Exponential-Exponential distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x)= \sigma \nu \exp(-\nu x) (1 - \exp(-\nu x))^{\sigma - 1} (1 - \exp(-\mu \nu x)) / 1 - \sigma B(\mu + 1, \sigma),}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{\nu > 0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and  nu 
y <- rWGEE(n=1000, mu = 5, sigma = 0.5, nu = 1)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, family='WGEE',
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma and nu  
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))

# Example 2
# Generating random values under some model
n <- 500
x1 <- runif(n, min=0.4, max=0.6)
x2 <- runif(n, min=0.4, max=0.6)
mu <- exp(2 - x1)
sigma <- exp(1 - 3*x2)
nu <- 1
x <- rWGEE(n=n, mu, sigma, nu)

mod <- gamlss(x~x1, sigma.fo=~x2, nu.fo=~1, family=WGEE,
              control=gamlss.control(n.cyc=50000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
exp(coef(mod, what="nu"))
}
\references{
Mahdavi, A. (2015). Two weighted distributions generated by 
exponential distribution. Journal of Mathematical Extension, 9, 1-12.
}
\seealso{
\link{dWGEE}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
