% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_advanced.R
\name{fpop_detect}
\alias{fpop_detect}
\title{FPOP - Functional Pruning Optimal Partitioning}
\usage{
fpop_detect(data, penalty = "bic", min_segment = 2, cost_type = "mean")
}
\arguments{
\item{data}{Numeric vector of observations}

\item{penalty}{Penalty for adding a changepoint. Can be:
\itemize{
\item \code{"bic"}: log(n)
\item \code{"aic"}: 2
\item \code{"mbic"}: 3*log(n)
\item numeric: Custom penalty value
}}

\item{min_segment}{Minimum segment length (default: 2)}

\item{cost_type}{Type of cost function:
\itemize{
\item \code{"mean"}: Gaussian mean change (default)
\item \code{"meanvar"}: Gaussian mean and variance change
\item \code{"poisson"}: Poisson rate change
}}
}
\value{
List with:
\item{changepoints}{Vector of changepoint locations}
\item{cost}{Final optimal cost}
\item{n_candidates}{Average candidates per time point (efficiency metric)}
}
\description{
More efficient than PELT for certain data types by maintaining
piecewise quadratic cost functions instead of just minimum values.
Achieves O(n) complexity in practice.
}
\examples{
data <- c(rnorm(100, 0), rnorm(100, 3), rnorm(100, 1))
result <- fpop_detect(data, penalty = "bic")
print(result$changepoints)
}
\references{
Maidstone, R., Hocking, T., Rigaill, G., and Fearnhead, P. (2017).
On optimal multiple changepoint algorithms for large data.
Statistics and Computing, 27(2), 519-533.
}
