% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_deeplearning.R
\name{cpc_detect}
\alias{cpc_detect}
\title{Contrastive Predictive Coding for Changepoint Detection}
\usage{
cpc_detect(
  data,
  window_size = 64,
  encoding_dim = 32,
  n_negative = 10,
  prediction_steps = 5,
  epochs = 100,
  threshold = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{Numeric vector}

\item{window_size}{Window size (default: 64)}

\item{encoding_dim}{Encoding dimension (default: 32)}

\item{n_negative}{Number of negative samples (default: 10)}

\item{prediction_steps}{Future steps to predict (default: 5)}

\item{epochs}{Training epochs (default: 100)}

\item{threshold}{Detection threshold for representation distance}

\item{verbose}{Show progress}
}
\value{
List with changepoints and learned encodings
}
\description{
Uses self-supervised contrastive learning to detect changepoints
by identifying where the learned representations change significantly.
}
\references{
Oord, A. v. d., Li, Y., and Vinyals, O. (2018). Representation Learning
with Contrastive Predictive Coding
}
