% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{compare_methods}
\alias{compare_methods}
\title{Compare Multiple Detection Methods}
\usage{
compare_methods(
  data,
  methods = c("pelt", "binseg", "wbs", "bocpd"),
  true_changepoints = NULL,
  tolerance = 5,
  ...
)
}
\arguments{
\item{data}{Numeric vector or matrix}

\item{methods}{Character vector of method names}

\item{true_changepoints}{Vector of true changepoints (for evaluation)}

\item{tolerance}{Tolerance for evaluation metrics}

\item{...}{Additional arguments passed to detect_regimes}
}
\value{
Object of class "regime_comparison"
}
\description{
Runs multiple detection methods on the same data and compares results.
}
\examples{
true_cp <- c(50, 100)
data <- c(rnorm(50), rnorm(50, mean = 2), rnorm(50))

comparison <- compare_methods(
  data,
  methods = c("pelt", "binseg"),
  true_changepoints = true_cp
)

}
