% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{cgmrf}
\alias{cgmrf}
\title{Multivariate Gaussian copula constructor parameterised by inverse correlation matrix}
\usage{
cgmrf(Q)
}
\arguments{
\item{Q}{Inverse of a positive definite correlation matrix with unit diagonal. Can either be sparse or dense matrix.}
}
\value{
Function with matrix argument \code{U} returning log copula density.
}
\description{
Returns a function computing the log density of the multivariate Gaussian copula,
parameterised by the inverse correlation matrix.
}
\details{
\strong{Caution:} Parameterising the inverse correlation directly is difficult, as inverting it needs to yield a positive definite matrix with \strong{unit diagonal}.
Hence we still advise parameterising the correaltion matrix \code{R} and computing its inverse.
This function is useful when you need access to the precision (i.e. inverse correlation) in your likelihood function.
}
\examples{
x <- c(0.5, 1); y <- c(1, 2); z <- c(0.2, 0.8)
d1 <- dnorm(x, 1, log = TRUE); d2 <- dexp(y, 2, log = TRUE); d3 <- dbeta(z, 2, 1, log = TRUE)
p1 <- pnorm(x, 1); p2 <- pexp(y, 2); p3 <- pbeta(z, 2, 1)
R <- matrix(c(1,0.5,0.3,0.5,1,0.4,0.3,0.4,1), nrow = 3)

## Based on correlation matrix
dmvcopula(cbind(d1, d2, d3), cbind(p1, p2, p3), copula = cmvgauss(R), log = TRUE)

## Based on precision matrix
Q <- solve(R)
dmvcopula(cbind(d1, d2, d3), cbind(p1, p2, p3), copula = cgmrf(Q), log = TRUE)

## Parameterisation inside a model
# using RTMB::unstructured to get a valid correlation matrix
library(RTMB)
d <- 5 # dimension
cor_func <- unstructured(d)
npar <- length(cor_func$parms())
R <- cor_func$corr(rep(0.1, npar))
}
\seealso{
\code{\link[=cmvgauss]{cmvgauss()}}
}
