\name{weibull}
\alias{weibull}
\title{Weibull model }
\usage{
weibull (M_infinite, a, b, t)
}
\arguments{
\item{M_infinite}{maximum migrated amount}
\item{a}{constant that reflects the rate of the release process}
\item{b}{an exponent that characterizes the nature of the release mechanism}
\item{t}{time}
}
\value{
Amount of drug released at time t Gallic Acid Equivalents per gram (GAE/gm)
}
\description{Weibull model is significant for describing non-linear and heterogeneous migration behaviour in active packaging systems.

Principle:

Principle of this model lies that polyphenol migration is governed by heterogeneous and possibly multi-mechanistic processes within the polymer matrix, offering a comprehensive description of release kinetics in active packaging systems. It provides a flexible empirical approach capable of describing complex and non-ideal release behaviour that do not strictly follow zero-order, first-order, or Higuchi kinetics (Ramos et al., 2014; Malekjani et al., 2024).

}
\examples{
  weibull (2, 0.015, 0.75, 24)
}
\references{
Ramos, M., Beltrán, A., Peltzer, M., Valente, A. J., & del Carmen Garrigós, M. (2014). Release and antioxidant activity of carvacrol and thymol from polypropylene active packaging films. LWT-Food Science and Technology, 58(2), 470-477.

Malekjani, N., Karimi, R., Assadpour, E., & Jafari, S. M. (2024). Control of release in active packaging/coating for food products; approaches, mechanisms, profiles, and modeling. Critical reviews in food science and nutrition, 64(29), 10789-10811.
}
\keyword{Weibull model}
