\name{korsmeyer_peppas}
\alias{korsmeyer_peppas}
\title{Korsmeyer Peppas model }
\usage{
  korsmeyer_peppas (M_infinite, k, t, n)
}
\arguments{
\item{M_infinite}{maximum migrated amount}
\item{k}{a constant that reflects the release rate and is influenced by the
properties of the drug and the polymeric matrix}
\item{n}{an exponent that characterizes the release mechanism}
\item{t}{time}
}
\value{
Amount of drug released at time t Gallic Acid Equivalents per gram (GAE/gm)
}
\description{The Korsmeyer–Peppas model describes the dominant release mechanism in systems where the exact transport process is complex or not purely diffusion-controlled.

Principle:

Korsmeyer–Peppas model is based on the principle of a power-law relationship between the fraction of active compound released over time. The model introduces a release exponent that characterizes the underlying transport mechanism within the polymer matrix. This exponent indicates whether migration follows Fickian diffusion, anomalous (non-Fickian) transport involving coupled diffusion and polymer relaxation, or case II transport governed primarily by polymer swelling or chain relaxation (Ramos et al., 2014; Malekjani et al., 2024).

}
\examples{
  korsmeyer_peppas(2, 0.18, 24, 0.45)
}
\references{
Ramos, M., Beltrán, A., Peltzer, M., Valente, A. J., & del Carmen Garrigós, M. (2014). Release and antioxidant activity of carvacrol and thymol from polypropylene active packaging films. LWT-Food Science and Technology, 58(2), 470-477.

Malekjani, N., Karimi, R., Assadpour, E., & Jafari, S. M. (2024). Control of release in active packaging/coating for food products; approaches, mechanisms, profiles, and modeling. Critical reviews in food science and nutrition, 64(29), 10789-10811.
}
\keyword{Korsmeyer Peppas model}
