% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{ctd}
\alias{ctd}
\title{Canopy Temperature Depression (CTD)}
\usage{
ctd(Gen, amb.temp, CT_PI)
}
\arguments{
\item{Gen}{Character vector of genotype IDs.}

\item{amb.temp}{Numeric scalar; ambient temperature (°C) (user must define this input).}

\item{CT_PI}{Numeric vector; canopy temperature (°C) at phase I (PI).}
}
\value{
A list of output columns:
\itemize{
\item \code{Gen}: Character vector of genotype IDs.
\item \code{CTD}: Canopy temperature depression (CTD) values for respective genotypes.
}
}
\description{
This function computes canopy temperature depression (CTD). For more details see Watson (1958) \url{doi:10.1093/oxfordjournals.aob.a083596}.
}
\examples{
# Creating a sample dataset
df <- data.frame(
Gen = c("V1","V2","V3"),
CT_PI   = c(26.7,31.4,28.4)
)
ctd(df$Gen, amb.temp = 34.2, CT_PI = df$CT_PI)

}
\references{
Watson, D.J. (1958). \url{doi:10.1093/oxfordjournals.aob.a083596}.
}
