% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyDiagnostics.R
\name{shinyDiagnostics}
\alias{shinyDiagnostics}
\title{Create a shiny app summarising your phenotyping results}
\usage{
shinyDiagnostics(
  result,
  directory,
  minCellCount = 5,
  open = rlang::is_interactive(),
  expectations = NULL
)
}
\arguments{
\item{result}{A summarised result}

\item{directory}{Directory where to save report}

\item{minCellCount}{Minimum cell count for suppression when exporting results.}

\item{open}{If TRUE, the shiny app will be launched in a new session. If
FALSE, the shiny app will be created but not launched.}

\item{expectations}{Data frame or tibble with cohort expectations. It must contain the following columns: cohort_name, estimate, value, and source.}
}
\value{
A shiny app
}
\description{
A shiny app that is designed for any diagnostics results from phenotypeR, this
includes:

* A diagnostics on the database via `databaseDiagnostics`.
* A diagnostics on the cohort_codelist attribute of the cohort via `codelistDiagnostics`.
* A diagnostics on the cohort via `cohortDiagnostics`.
* A diagnostics on the population via `populationDiagnostics`.
* A diagnostics on the matched cohort via `matchedDiagnostics`.
}
\examples{
\donttest{
library(omock)
library(CohortConstructor)
library(PhenotypeR)

cdm <- mockCdmFromDataset(source = "duckdb")
cdm$warfarin <- conceptCohort(cdm,
                              conceptSet =  list(warfarin = c(1310149L,
                                                              40163554L)),
                              name = "warfarin")

result <- phenotypeDiagnostics(cdm$warfarin)

expectations <- dplyr::tibble("cohort_name" = "warfarin",
                       "value" = c("Mean age",
                                   "Male percentage",
                                   "Survival probability after 5y"),
                       "estimate" = c("32", "74\%",  "4\%"),
                       "source" = c("AlbertAI"))

shinyDiagnostics(result, tempdir(), expectations = expectations)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
