% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDeath.R
\name{addDeathDays}
\alias{addDeathDays}
\title{Add days to death for individuals. Only death within the same observation
period than \code{indexDate} will be observed.}
\usage{
addDeathDays(
  x,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  window = c(0, Inf),
  deathDaysName = "days_to_death",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the window origin.}

\item{censorDate}{Name of a column to stop followup.}

\item{window}{window to consider events over.}

\item{deathDaysName}{name of the new column to be added.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
table x with the added column with death information added.
}
\description{
Add days to death for individuals. Only death within the same observation
period than \code{indexDate} will be observed.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addDeathDays()

}

}
