\name{softmax_weights}
\alias{softmax_weights}
\title{Compute Softmax Weights}
\description{
Calculates softmax weights for a vector of component scores using a
temperature parameter that controls weight concentration.
}
\usage{
softmax_weights(scores, temperature = 0.13)
}
\arguments{
  \item{scores}{Numeric vector of component scores (at least 2 elements).}
  \item{temperature}{Numeric. Temperature parameter. Lower = sharper
    weights. Default is 0.13.}
}
\value{
Numeric vector of weights summing to 1. Named if input is named.
}
\details{
\deqn{W_i = \frac{\exp(C_i / T)}{\sum_j \exp(C_j / T)}}

Uses the log-sum-exp trick for numerical stability.
}
\examples{
softmax_weights(c(MSG = 0.8, MRG = 1.0, cMTG = 0.6))
softmax_weights(c(MSG = 0.8, MRG = 0.0, cMTG = 0.7))
softmax_weights(c(0.8, 0.5, 0.3), temperature = 1.0)
}
\seealso{\code{\link{calibrate_temperature}}, \code{\link{compute_psri_sm}}}
