% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newPolr.R
\name{newpolr}
\alias{newpolr}
\title{slightly modified version of polr from MASS}
\usage{
newpolr(
  formula,
  data,
  weights,
  start,
  ...,
  subset,
  na.action,
  contrasts = NULL,
  Hess = FALSE,
  model = TRUE,
  method = c("logit", "probit", "cloglog", "loglog", "cauchit")
)
}
\arguments{
\item{formula}{a formula}

\item{data}{an optional data frame, list or environment (or object
coercible by \code{\link{as.data.frame}} to a data frame) containing
the variables in the model.  If not found in \code{data}, the
variables are taken from \code{environment(formula)}, typically the
environment from which \code{cobot} is called.}

\item{weights}{optional case weights in fitting.  Default to 1.}

\item{start}{initial values for the parameters.}

\item{...}{additional arguments to be passed to \code{\link{optim}}, most
often a \code{control} argument.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the
data contain \code{NA}s.  The default is is \code{\link{na.fail}}.
Another possible value is \code{NULL}, no action.  Value
\code{\link{na.exclude}} can be useful.}

\item{contrasts}{a list of contrasts to be used for some or all of the
factors appearing as variables in the model formula.}

\item{Hess}{logical for whether the Hessian (the observed information
matrix) should be returned.  Use this if you intend to call
\code{\link{summary}} or \code{\link{vcov}} on the fit.}

\item{model}{logical for whether the model matrix should be returned.}

\item{method}{logistic or probit or complementary log-log, loglog, or
cauchit (corresponding to a Cauchy latent variable).}
}
\value{
A object of class \code{"polr"}.  This has components
\item{coefficients}{the coefficients of the linear predictor, which has no
intercept.}
\item{zeta}{the intercepts for the class boundaries.}
\item{deviance}{the residual deviance.}
\item{fitted.values}{a matrix, with a column for each level of the response.}
\item{lev}{the names of the response levels.}
\item{terms}{the \code{terms} structure describing the model.}
\item{df.residual}{the number of residual degrees of freedoms, calculated
using the weights.}
\item{edf}{the (effective) number of degrees of freedom used by the model}
\item{n, nobs}{the (effective) number of observations, calculated using the
weights. (\code{nobs} is for use by \code{\link[MASS]{stepAIC}}).}
\item{call}{the matched call.}
\item{method}{the matched method used.}
\item{convergence}{the convergence code returned by \code{optim}.}
\item{niter}{the number of function and gradient evaluations used by
\code{\link{optim}}.}
\item{lp}{the linear predictor (including any offset).}
\item{Hessian}{(if \code{Hess} is true).  Note that this is a numerical
approximation derived from the optimization proces.}
\item{model}{(if \code{model} is true).}
}
\description{
slightly modified version of polr from MASS
}
\references{
polr from MASS
}
\seealso{
\code{\link{optim}}, \code{\link{glm}},
    \code{\link[nnet]{multinom}}
}
