% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PKPDindex.R
\name{PKPDindex}
\alias{PKPDindex}
\title{PKPDindex: Optimal PK/PD Index Finder}
\usage{
PKPDindex(
  dataset,
  x_columns = NULL,
  y_column = "response",
  E0_fix,
  Emax_fix,
  EC50_init = NULL,
  maxiter = 500,
  tol = 1e-05,
  minFactor = 1e-07,
  select_mod = NULL,
  plot_results = FALSE,
  srow = FALSE,
  xlim = NULL,
  ylim = NULL,
  point_color = NULL,
  line_color = NULL,
  x_label = NULL,
  y_label = NULL,
  plot_title = NULL,
  log_scale_x = NULL,
  title_cex = 1.2,
  label_cex = 1,
  axis_cex = 1,
  detail_cex = 1
)
}
\arguments{
\item{dataset}{A data frame containing the independent (x) and dependent (y) variables.}

\item{x_columns}{A character vector specifying the x-axis variables (PK/PD indices).
If NULL (default), the function attempts to detect appropriate columns from the dataset,
specifically \code{"auc_mic"}, \code{"cmax_mic"}, and \code{"t_mic"}. If these are not found, the user must specify the names manually.
\itemize{
\item \code{"auc_mic"}: area under the concentration-time curve divided by the MIC.
\item \code{"cmax_mic"}: peak drug concentration divided by the MIC.
\item \code{"t_mic"}: time above MIC (duration the drug concentration exceeds MIC).
Users should calculate these indices based on their PK data before using this function.
}}

\item{y_column}{A character string specifying the response variable.
Default name is \code{"response"}.The response should be the log10-transformed change in CFU/ml (Delta log10 CFU/ml).
Users can either provide a column with pre-calculated log10 CFU/ml changes,
or provide raw CFU/ml counts at the initial (CFU_init) and 24-hour timepoint (CFU_24)
, and the function will automatically calculate the log10 change in CFU/ml (Delta log10 CFU/ml).}

\item{E0_fix}{Fixed E0 (baseline effect) value.}

\item{Emax_fix}{Fixed Emax (maximum effect) value.}

\item{EC50_init}{Optional numeric vector specifying initial EC50 values for each x_column. Defaults to NULL, and values are estimated automatically.}

\item{maxiter}{Maximum number of iterations - Specifies the maximum number of iterations allowed for the nonlinear least squares (NLS) fitting process. Higher values may help convergence for complex models. Default maxiter = 500.}

\item{tol}{Tolerance level - Defines the tolerance for convergence in the NLS algorithm. Lower values indicate stricter convergence criteria. Default tol = 1e-5.}

\item{minFactor}{Minimum step factor - Determines the smallest step size used in parameter updates during the NLS fitting process, controlling the precision of optimisation. Default minFactor = 1e-7.}

\item{select_mod}{Optional named list specifying preferred models for each x_column.}

\item{plot_results}{Logical; if TRUE, the function generates model fit plots.}

\item{srow}{Single row plotting - Logical (TRUE or FALSE). If TRUE, plots all best model fits in a single row for visual comparison.}

\item{xlim}{A numeric vector of length 2 specifying x-axis limits.}

\item{ylim}{A numeric vector of length 2 specifying y-axis limits.}

\item{point_color}{Optional character string specifying the point colour in plots.}

\item{line_color}{Optional character string specifying the line colour in plots.}

\item{x_label}{Optional named list specifying custom x-axis labels.}

\item{y_label}{Optional character string specifying a custom y-axis label.}

\item{plot_title}{Optional character string specifying a custom plot title.}

\item{log_scale_x}{Optional named list specifying whether to apply log10 scaling to x-axis for each x_column.}

\item{title_cex}{Size of the plot title text. Default title_cex = 1.2.}

\item{label_cex}{Size of the axis title. Default label_cex = 1.0.}

\item{axis_cex}{Size of the axis labels. Default axis_cex = 1.0.}

\item{detail_cex}{Size of the model detail text on the plot. Default detail_cex = 1.0.}
}
\value{
A list containing:
\itemize{
\item \strong{All_Model_Results}: A data frame with results from all fitted models.
\item \strong{Best_Models}: A data frame with the best model (lowest AIC) for each PK/PD index.
\item \strong{Plots}: A list of recorded plots (if \code{plot_results = TRUE}).
}
}
\description{
This function fits various Emax models to a given dataset, allowing for flexibility in model selection, initial parameter estimates, and plotting options.
}
\details{
The function fits different variations of the Emax model to describe the relationship between PK/PD indices and response.
The available models (m1 to m8) are defined as follows:
\itemize{
\item \strong{m1}: Fixed E0 and Emax, no Hill coefficient.
\item \strong{m2}: Fixed E0 and Emax, with Hill coefficient (gam).
\item \strong{m3}: Fixed E0, estimated Emax, no Hill coefficient.
\item \strong{m4}: Fixed E0, estimated Emax, with Hill coefficient.
\item \strong{m5}: Estimated E0, fixed Emax, no Hill coefficient.
\item \strong{m6}: Estimated E0, fixed Emax, with Hill coefficient.
\item \strong{m7}: Estimated E0 and Emax, no Hill coefficient.
\item \strong{m8}: Fully estimated model (E0, Emax, EC50, and gam).
}

Users can select specific models using the \code{select_mod} argument.
}
\examples{
# Basic usage with default settings
 output <- PKPDindex(
  dataset = PKPDindex_data,
  E0_fix = 1.5,
  Emax_fix = 4.8
)
# Custom x and y columns and initial data
 output <- PKPDindex(
  dataset = PKPDindex_data,
  E0_fix = 1.5,
  Emax_fix = 4.8,
  x_columns = c("auc_mic","cmax_mic","t_mic"),
  y_column = "response",
  EC50_init = c(1,1,1)
)

# Generate and custom plots
 output <- PKPDindex(
  dataset = PKPDindex_data,
  E0_fix = 1.5,
  Emax_fix = 4.8,
  plot_results = TRUE,
  srow=TRUE,
  xlim = c(0, 50),
  ylim = c(-2, 10),
  point_color = "green",
  line_color = "purple",
  select_mod = list(auc_mic = "m5", t_mic = "m1"),
  x_label = list(auc_mic = "AUC/MIC", cmax_mic = "Cmax/MIC", t_mic = "Time>MIC"),
  y_label = "Log10 Change in CFU",
  plot_title = "Model Fitting Results",
  log_scale_x = list(auc_mic = TRUE, cmax_mic = TRUE,t_mic=FALSE),
  title_cex = 2,
  label_cex = 1.5,
  axis_cex = 1.4,
  detail_cex = 1.3
)

#' # To view the best models:
output$Best_Models

# To view all model results:
output$All_Model_Results

# To access a specific plot:
output$Plots[["cmax_mic"]]
}
