\name{gar}
\title{Generalized autoregression}
\usage{
gar(response, distribution="normal", times, totals=NULL, censor=NULL,
	delta=NULL, mu, shape=NULL, preg=NULL, pdepend=NULL,
	pshape=NULL, transform="identity", link="identity",
	autocorr="exponential", order=1, print.level=0, ndigit=10,
	gradtol=0.00001,steptol=0.00001, fscale=1, iterlim=100,
	typsiz=abs(p), stepmax=10*sqrt(p\%*\%p))
}
\alias{gar}
\alias{coefficients.gar}
\alias{deviance.gar}
\alias{fitted.gar}
\alias{residuals.gar}
\alias{print.gar}
\arguments{
\item{response}{A list of two or three column matrices with responses,
corresponding times, and possibly a censor indicator, for each
individual, one matrix or dataframe of responses, or an object of
class, response (created by \code{\link{restovec}}).}
\item{distribution}{The distribution to be fitted: Bernoulli, Poisson,
exponential, negative binomial, mult Poisson, double Poisson, beta
binomial, mult binomial, double binomial, normal, inverse Gauss,
logistic, gamma, Weibull, Cauchy, Laplace, Levy, Pareto, gen(eralized)
gamma, gen(eralized) logistic, Hjorth, Burr, gen(eralized) Weibull,
gen(eralized) extreme value, gen(eralized) inverse Gauss, or power
exponential.}
\item{times}{When response is a matrix, a vector of possibly unequally
spaced times when they are the same for all individuals or a matrix of
times. Not necessary if equally spaced.}
\item{totals}{An appropriate scalar, vector, or matrix of binomial
totals (only applicable for binomial, beta binomial, mult binomial,
double binomial).}
\item{censor}{If response is a matrix, a matrix of the same size
containing the censor indicator: 1=uncensored, 0=right-censored,
-1=left-censored.}
\item{delta}{Scalar or vector giving the unit of measurement for each
response value, set to unity by default. For example, if a response is
measured to two decimals, delta=0.01. If the response has been
pretransformed, this must be multiplied by the Jacobian. This
transformation cannot contain unknown parameters. For example, with a
log transformation, \code{delta=1/y}. (The delta values for the
censored response are ignored.) The jacobian is calculated
automatically for the transform option.}
\item{mu}{The location regression function. It must return a vector
with a value for each observation on each individual.}
\item{shape}{An optional shape regression function.}
\item{preg}{The initial parameter estimates for the location
regression function.}
\item{pdepend}{One or two estimates of the dependence parameters for
the Kalman update. With one, it is Markovian and, with two, it is
nonstationary. For the latter, the \code{order} must be one.}
\item{pshape}{Zero to two estimates for the shape parameters of the
distribution if \code{shape} is not a function; otherwise, estimates
for the parameters in this function, with one extra at the end for
three-parameter distributions.}
\item{transform}{Transformation of the response variable: \code{identity},
\code{exp}, \code{square}, \code{sqrt}, or \code{log}.}
\item{link}{Link function for the mean: \code{identity}, \code{exp},
\code{square}, \code{sqrt}, \code{log}, \code{logit}, or
\code{cloglog} (last two only for binary data).}
\item{autocorr}{The form of the (second if two) dependence function:
\code{exponential} is the usual rho^|t_i-t_j|; \code{gaussian} is
rho^((t_i-t_j)^2); \code{cauchy} is 1/(1+rho(t_i-t_j)^2);
\code{spherical} is ((|t_i-t_j|rho)^3-3|t_i-t_j|rho+2)/2 for
|t_i-t_j|<=1/rho and zero otherwise; \code{IOU} is the integrated
Ornstein-Uhlenbeck process, (2rho min(t_i,t_j)+exp(-rho t_i)
+exp(-rho t_j)-1 -exp(rho|ti-t_j|))/2rho^3.}
\item{order}{First- or second-order stationary autoregression.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{gar} fits a first- or second-order generalized autoregression,
possibly with Kalman update over time (first-order only).

Marginal and individual profiles can be plotted using
\code{\link{plot.profile}} and \code{\link{plot.iprofile}} and
residuals with \code{\link{plot.residuals}}.

Lindsey, J.K. (1997) Applying Generalized Linear Models. Springer,
pp.\ 93--101

See also Lambert, P. (1996) Statistics in Medicine 15, 1695-1708
}
\value{
A list of classes \code{gar} and \code{recursive} is returned.
}
\seealso{
\code{\link{carma}}, \code{\link{elliptic}}, \code{\link{gnlmm}},
\code{\link{gnlr}}, \code{\link{kalcount}}, \code{\link{kalseries}},
\code{\link{kalsurv}}, \code{\link{plot.profile}}, \code{\link{plot.iprofile}},
\code{\link{plot.residuals}}, \code{\link{read.list}}, \code{\link{restovec}},
\code{\link{rmna}}, \code{\link{tcctomat}}, \code{\link{tvctomat}}.
}
\examples{
mu <- function(p) p[1]*log(y0)+(times<30)*p[2]*
	(times-30)+(times>30)*p[3]*(times-30)
# first-order generalized AR
gar(y, dist="Weibull", times=tt, preg=c(1.3,0.008,-0.05),
	pdep=0.5, mu=mu, link="log")
# second-order generalized AR
gar(y, dist="Weibull", times=tt, preg=c(1.3,0.008,-0.05),
	pdep=c(0.5,0.1), mu=mu, link="log", order=2)
# first-order generalized AR with Kalman update
gar(y, dist="Weibull", times=tt, preg=c(1.3,0.008,-0.05),
	pdep=c(1.2,0.5), mu=mu, link="log")
}
