\name{pbirth}
\title{Fit a Generalized Negative Binomial Process as a Birth Process}
\usage{
pbirth(fr, p, nbin=F, n=20, k=3)
}
\alias{pbirth}
\arguments{
\item{fr}{Series of frequencies.}
\item{p}{Vector of initial estimates.}
\item{nbin}{If TRUE, fits a negative binomial process.}
\item{n}{Number of terms in the series expansion for matrix exponentiation.}
\item{k}{Constant divisor to avoid over- or underflow for matrix
exponentiation.}
}
\description{
\code{pbirth} fits a generalized negative binomial process as a birth process.
}
\examples{
y <- rnbinom(100,5,0.7)
fr <- tabulate(y)
pbirth(fr,p=c(log(-log(0.7)),log(5)),nbin=T)
pbirth(fr,p=c(log(-log(0.7)),log(5),-1))
}
