% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModInvGE.r
\name{ModInvGE}
\alias{ModInvGE}
\alias{dmod.inv.gen.exp}
\alias{pmod.inv.gen.exp}
\alias{qmod.inv.gen.exp}
\alias{rmod.inv.gen.exp}
\alias{hmod.inv.gen.exp}
\title{Modified Inverse Generalized Exponential(MIGE) Distribution}
\usage{
dmod.inv.gen.exp(x, alpha, beta, lambda, log = FALSE)
pmod.inv.gen.exp(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qmod.inv.gen.exp(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rmod.inv.gen.exp(n, alpha, beta, lambda)
hmod.inv.gen.exp(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dmod.inv.gen.exp}: numeric vector of (log-)densities
  \item \code{pmod.inv.gen.exp}: numeric vector of probabilities
  \item \code{qmod.inv.gen.exp}: numeric vector of quantiles
  \item \code{rmod.inv.gen.exp}: numeric vector of random variates
  \item \code{hmod.inv.gen.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the MIGE distribution.
}
\details{
The MIGE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Modified Inverse Generalized Exponential(MIGE) distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\left[1-\exp \left(-\lambda x^{-1} e^{-\beta x}\right)
\right]^\alpha  \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dmod.inv.gen.exp()} — Density function
  \item \code{pmod.inv.gen.exp()} — Distribution function
  \item \code{qmod.inv.gen.exp()} — Quantile function
  \item \code{rmod.inv.gen.exp()} — Random generation
  \item \code{hmod.inv.gen.exp()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dmod.inv.gen.exp(x, 2.0, 0.5, 0.2)
pmod.inv.gen.exp(x, 2.0, 0.5, 0.2)
qmod.inv.gen.exp(0.5, 2.0, 0.5, 0.2)
rmod.inv.gen.exp(10, 2.0, 0.5, 0.2)
hmod.inv.gen.exp(x, 2.0, 0.5, 0.2)

# Data
x <- fibers69
# ML estimates
params = list(alpha=30.7790, beta=0.1942, lambda=14.8297)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pmod.inv.gen.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qmod.inv.gen.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dmod.inv.gen.exp, pfun=pmod.inv.gen.exp, plot=TRUE)
print.gofic(out)

}
\references{
Krishna, H., & Kumar, K. (2013). 
Reliability estimation in generalized inverted exponential distribution 
with progressive type II censored sample. \emph{Journal of
Statistical Computation and Simulation}, \bold{83(6)}, 1007--1019.

Telee, L. B. S., & Kumar, V. (2023). 
Modified Inverse Generalized Exponential Distribution : Model and Properties.
\emph{Int. J. Res. Granthaalayah}, \bold{11(8)}, 96--111. 
\doi{10.29121/granthaalayah.v11.i8.2023.5288}
}
