% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fda_drug_labels.R
\name{get_fda_drug_labels}
\alias{get_fda_drug_labels}
\title{Search Drug Labels by Drug Name in FDA Drug Labeling Database}
\source{
FDA Drug Labeling Database via openFDA:
\url{https://open.fda.gov/apis/drug/label/}
}
\usage{
get_fda_drug_labels(drug_name)
}
\arguments{
\item{drug_name}{A character string representing the name of the drug.}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{product_id}: Unique identifier for the product
  \item \code{brand_name}: Brand or trade name of the product
  \item \code{generic_name}: Generic name of the active ingredient
  \item \code{manufacturer}: Name of the manufacturer
  \item \code{product_type}: Type of drug product
  \item \code{route}: Route of administration
  \item \code{indications}: Approved indications for use
  \item \code{warnings}: Important warnings and precautions
}
}
\description{
Retrieves drug label information from the FDA Drug Labeling Database
that match a specific drug name using the RESTful API endpoint
\code{/drug/label.json?search=<drug_name>}.

This includes details such as the product ID, brand name, generic name,
indications and usage, dosage and administration, warnings,
drug interactions, and other prescribing information from FDA-approved drug labels.
}
\details{
This function sends a GET request to the FDA openFDA API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

If the API request fails, returns no matches, or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from FDA
  get_fda_drug_labels("aspirin")
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
