% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formMWRwqx.R
\name{formMWRwqx}
\alias{formMWRwqx}
\title{Format WQX metadata input}
\usage{
formMWRwqx(wqxdat)
}
\arguments{
\item{wqxdat}{input data frame for wqx metadata}
}
\value{
A formatted data frame of the WQX metadata file
}
\description{
Format WQX metadata input
}
\details{
This function is used internally within \code{\link{readMWRwqx}} to format the input data for downstream analysis.  The formatting includes:

\itemize{
\item Convert characteristic names: All parameters in \code{Characteristic Name} are converted to \code{Simple Parameter} in \code{\link{paramsMWR}} as needed
}
}
\examples{
library(dplyr)

wqxpth <- system.file('extdata/ExampleWQX.xlsx', package = 'MassWateR')

wqxdat <- suppressWarnings(readxl::read_excel(wqxpth, na = c('NA', 'na', ''), col_types = 'text'))
  
formMWRwqx(wqxdat)
}
