% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_correl.R
\name{r_correl}
\alias{r_correl}
\alias{r.correl}
\title{r to Coefficient of Determination (R\eqn{^2}) from F}
\usage{
r_correl(r, n, a = 0.05)

r.correl(r, n, a = 0.05)
}
\arguments{
\item{r}{correlation coefficient}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
\describe{
  \item{r}{correlation coefficient}
  \item{rlow}{lower level confidence interval for \eqn{r}}
  \item{rhigh}{upper level confidence interval for \eqn{r}}
  \item{R2}{coefficient of determination}
  \item{R2low}{lower level confidence interval of \eqn{R^2}}
  \item{R2high}{upper level confidence interval of \eqn{R^2}}
  \item{se}{standard error}
  \item{n}{sample size}
  \item{dfm}{degrees of freedom of mean}
  \item{dfe}{degrees of freedom of error}
  \item{t}{\eqn{t}-statistic}
  \item{F}{\eqn{F}-statistic}
  \item{p}{p-value}
  \item{estimate}{the \eqn{r} statistic and confidence interval
in APA style for markdown printing}
  \item{estimateR2}{the \eqn{R^2} statistic and confidence interval
in APA style for markdown printing}
  \item{statistic}{the \eqn{t}-statistic in APA style for markdown printing}
}
}
\description{
This function displays the transformation from \eqn{r} to
\eqn{R^2} to calculate the non-central confidence interval
for \eqn{R^2} using the \eqn{F} distribution.
}
\details{
The \eqn{t}-statistic is calculated by:
\deqn{t = \frac{r}{\sqrt{\frac{1 - r^2}{n - 2}}}}

The \eqn{F}-statistic is the \eqn{t}-statistic squared:
\deqn{F = t^2}

\href{https://www.aggieerin.com/shiny-server/tests/rcorrel.html}{Learn more on our example page.}

**Note on function and output names:** This effect size is now implemented
with the snake_case function name `r_correl()` to follow modern R style
guidelines. The original dotted version `r.correl()` is still available as
a wrapper for backward compatibility, and both functions return the same
list. The returned object includes both the original element names (e.g.,
`r`, `rlow`, `rhigh`, `R2`, `R2low`, `R2high`, `se`, `n`, `dfm`, `dfe`,
`t`, `F`, `p`, `estimate`, `estimateR2`, `statistic`) and newer snake_case
aliases (e.g., `r_value`, `r_lower_limit`, `r_upper_limit`, `r2_value`,
`r2_lower_limit`, `r2_upper_limit`, `standard_error`, `sample_size`,
`df_model`, `df_error`, `t_value`, `f_value`, `p_value`). New code should
prefer `r_correl()` and the snake_case output names, but existing code
using the older names will continue to work.
}
\examples{

# This example is derived from the mtcars dataset provided in R.

# What is the correlation between miles per gallon and car weight?

cor.test(mtcars$mpg, mtcars$wt)

r_correl(r = -0.8676594, n = 32, a = .05)

# Backwards-compatible dotted name (deprecated)
r.correl(r = -0.8676594, n = 32, a = .05)
}
\keyword{correlation}
\keyword{effect}
\keyword{size}
