% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_MoransI.R
\name{calc_MoransI}
\alias{calc_MoransI}
\title{Calculate Moran's I}
\usage{
calc_MoransI(
  object,
  df_neighbours = NULL,
  spatial_autocorrelation = TRUE,
  compute_pseudo_p = FALSE,
  tested_moransI = NULL,
  n_permutations = 999,
  ignore_borders = FALSE,
  return_intermediate_values = FALSE
)
}
\arguments{
\item{object}{\linkS4class{RLum.Results} or \link{numeric} (\strong{required}) containing
the values of the grains of one. Should have length 100; can contain \code{NA}
values.}

\item{df_neighbours}{\link{data.frame} (\emph{with default}): a data frame with 3
columns (\code{location}, \code{neighbour} and \code{weight}, respectively), with each row
indicating the index of one location and one of its neighbours (note that
the concept of "location" versus "neighbour" is symmetric, so each
neighbouring pair needs to be specified only once), alongside their relative
weight (generally set to 1). If \code{NULL} (default), this is constructed
automatically by the internal function \code{.get_Neighbours}.}

\item{spatial_autocorrelation}{\link{logical} (\emph{with default}): whether spatial
autocorrelation should be considered in the computation of Moran's I
(\code{TRUE} by default). If \code{FALSE}, the function computes Moran's I expected
value in case of no autocorrelation (H_0). See details for further
information.}

\item{compute_pseudo_p}{\link{logical} (\emph{with default}): whether a pseudo p-value
should be computed (\code{FALSE} by default).}

\item{tested_moransI}{\link{numeric} (\emph{with default}): The value of Moran's I to
be tested against when computing the pseudo p-value. If \code{NULL} (default), the
value calculated by the function will be used. Ignored if \code{compute_pseudo_p}
is \code{FALSE}.}

\item{n_permutations}{\link{integer} (\emph{with default}): number of random
permutations tested to calculate the fraction which is the pseudo p
(defaults to 999). Influences the calculation speed, which will have
impact in case of large scale simulation loops. Ignored if \code{compute_pseudo_p}
is \code{FALSE}.}

\item{ignore_borders}{\link{logical} (\emph{with default}): whether only grain
locations that do not lie on the border of the disc should be considered
(\code{FALSE} by default). Thus if \code{TRUE}, only the inner 8x8 grain locations
rather than the full 10x10 are considered. Ignored if \code{df_neighbours} is
not \code{NULL} or if \code{spatial_autocorrelation = FALSE}.}

\item{return_intermediate_values}{\link{logical} (\emph{with default}): whether the
function should return a list with several intermediate calculation results
(defaults to \code{FALSE}). Ignored if \code{spatial_autocorrelation} is \code{FALSE}.}
}
\value{
By default one numerical value, roughly between -1 and 1, where
close to zero means no spatial correlation, and value close to 1 a positive
spatial correlation given the pattern we interested in (by default all rook
neighbours). A value closer to -1 has no meaning within the context of
luminescence crosstalk. If \code{compute_pseudo_p = TRUE}, then the computed
pseudo p-value is returned. If \code{return_intermediate_values} is set to \code{TRUE},
a list with several values used for calculation is returned instead of a
single outcome.
}
\description{
Calculate Moran's I
}
\details{
\strong{Case of no spatial autocorrelation}

Perhaps a bit counter-intuitive, the expected value of Moran's I under the
null hypothesis of no spatial correlation is a value slightly smaller than
zero. When setting \code{spatial_autocorrelation = FALSE}, this function
calculates the expected value based on the number of observations or the
length of the observation vector (while taking out \code{NA} values). Note that
the expected value only depends on the number of observed separate grain
values. This can be useful for plotting.

The expected Moran's I for the null hypothesis of no spatial correlation
corresponds to \code{-1 / (n - 1)}, with \code{n} being the number of non-missing
observations.
}
\examples{

## Test a fictional sample with spatial correlation
calc_MoransI(object = c(1:100))

## Test some fictional samples without spatial correlation;
## note the randomness with each repetition
calc_MoransI(object = rnorm(n = 100))
calc_MoransI(object = rnorm(n = 100))
calc_MoransI(object = rnorm(n = 100))

} 

\section{How to cite}{
Boer, A.d., Steinbuch, L., 2025. calc_MoransI(): Calculate Moran's I. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\references{
de Boer, A-M., Steinbuch, L., Heuvelink, G.B.M., Wallinga, J., 2025.
A novel tool to assess crosstalk in single-grain luminescence detection.
Submitted.
}
\author{
Anna-Maartje de Boer, Luc Steinbuch, Wageningen University & Research, 2025
, RLum Developer Team}
